/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWInvokeWSOperationParameterTableModel;
import filenet.vw.toolkit.design.property.tables.VWParamExpressionCellEditor;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellItem;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.ws.api.WSOperation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

class VWInvokeWSOperationParameterPanel
extends JPanel
implements TableModelListener,
IVWTableActionListener,
ListSelectionListener {
    protected static final int PARAM_TYPE_INCOMING = 0;
    protected static final int PARAM_TYPE_OUTGOING = 1;
    private VWToolbarBorder m_operationParamBorder = null;
    private VWTable m_operationParamTable = null;
    protected VWInvokeWSOperationParameterTableModel m_operationParamTableModel = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWInvokeInstruction m_instructionDef = null;
    protected int m_nParamType = -1;
    private boolean m_isFirstTime = true;

    public VWInvokeWSOperationParameterPanel(VWAuthPropertyData authPropertyData, int nParamType) {
        this.m_authPropertyData = authPropertyData;
        this.m_nParamType = nParamType;
        this.layoutControls();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_operationParamTable != null) {
                int nWidth = this.m_operationParamTable.getViewPortWidth() / 3;
                int[] columnSizes = new int[]{nWidth, nWidth - 30, this.m_operationParamTable.getViewPortWidth() - (2 * nWidth - 30)};
                this.m_operationParamTable.fitColumnsInTable(columnSizes);
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_operationParamTable.getSelectedRow()) {
                    this.m_operationParamTable.clearSelection();
                }
                this.m_operationParamTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_operationParamTable == null) break;
                this.m_operationParamTable.stopEditing();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_operationParamBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationParamBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_operationParamTable.getSelectedRow();
            if (this.m_operationParamTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_operationParamTableModel.getRowCount()) - 1) {
                this.m_operationParamBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_operationParamBorder.getClientPanel(), 1, Integer.MAX_VALUE));
            }
        }
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        String borderTitle = null;
        switch (this.m_nParamType) {
            case 0: {
                borderTitle = VWResource.s_incomingParameters;
                break;
            }
            case 1: {
                borderTitle = VWResource.s_outgoingParameters;
            }
        }
        this.m_operationParamBorder = new VWToolbarBorder(borderTitle, 0x40000000);
        JPanel paramPanel = this.m_operationParamBorder.getClientPanel();
        paramPanel.setLayout(new BorderLayout());
        this.m_operationParamTableModel = this.createOperationParamTableModel();
        this.m_operationParamTableModel.addTableModelListener(this);
        this.m_operationParamTable = new VWTable(this.m_operationParamTableModel);
        this.m_operationParamTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
        this.m_operationParamTable.setDefaultRenderer(VWToolTipTableCellItem.class, new VWToolTipTableCellRenderer());
        this.m_operationParamTable.getSelectionModel().setSelectionMode(0);
        this.m_operationParamTable.getSelectionModel().addListSelectionListener(this);
        this.initTableCells();
        paramPanel.add(new JScrollPane(this.m_operationParamTable));
        this.add((Component)this.m_operationParamBorder, gbCons);
    }

    protected void initTableCells() {
        this.initTableCell(0, null);
        this.initTableCell(1, null);
        this.initTableCell(2, new VWParamExpressionCellEditor(this.m_authPropertyData));
    }

    protected void initTableCell(int cell, TableCellEditor cellEditor) {
        TableColumn tcElement = this.m_operationParamTable.getColumnModel().getColumn(cell);
        if (tcElement != null) {
            if (cellEditor != null) {
                tcElement.setCellEditor(cellEditor);
            }
            tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
        }
    }

    protected VWInvokeWSOperationParameterTableModel createOperationParamTableModel() {
        return new VWInvokeWSOperationParameterTableModel(this.m_authPropertyData, this.m_nParamType);
    }

    protected void reinitialize(VWInvokeInstruction instructionDef, WSOperation wsOperation) {
        this.m_instructionDef = instructionDef;
        VWWebServiceParameterDefinition[] paramDefs = null;
        if (this.m_instructionDef != null && this.m_operationParamTableModel != null) {
            VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
            if (wsOperation != null && wsUtils != null) {
                wsUtils.createInvokeParameters(this.m_instructionDef, wsOperation, this.m_nParamType == 0);
            }
            try {
                switch (this.m_nParamType) {
                    case 0: {
                        paramDefs = this.m_instructionDef.getInComingParameterDefinitions();
                        break;
                    }
                    case 1: {
                        paramDefs = this.m_instructionDef.getOutGoingParameterDefinitions();
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        this.m_operationParamTableModel.reinitialize(paramDefs);
    }
}

